-- events for ui screen


function OnLoad ()
	CacheSound ("mythpeople/mythpeople-sound.ogg");
end;

timer = 0;

function OnEnter ()
	PlaySound ("mythpeople/mythpeople-sound.ogg");
end;

function OnLeave ()
	SwitchMusic ("music/mainmenu.ogg", 0, 0);
end;


function OnClick (name)

	Print ("OnClick " .. name .. "\n");
end;


function clamp01 (value)

	value = math.min (value, 1);
	value = math.max (value, 0);
	return value;
end;

function OnUpdate (tdelta)

	timer = timer + tdelta;
	
	t = 1.1 * timer;
	
	trans = GetActiveScreenTransPhase ();

	SetProperty ("bluebg:alpha", trans * clamp01 (2*(t - 1.5)));
	SetProperty ("bluebg-small:alpha", trans * clamp01 (2*(t - 2)));
	SetProperty ("logo-curve:alpha", trans * clamp01 (2*(t - 0.7)));
	SetProperty ("logo-frame:alpha", trans * clamp01 (2*(t - 1.2)));
	SetProperty ("logo-human1:position_offset.y", math.min (0, -(0.4-2*t) * 500));
	SetProperty ("logo-human2:position_offset.y", math.min (0, -(0.5-2*t) * 600));
	SetProperty ("logo-text:position_offset.y", math.max (0, (0.9-t) * 800));
	
	-- show it for a couple of secs after it's complete, then fade away
	if (t > 4) then
		PopScreen ();
	end;
end;

function OnDraw ()

end;
